package com.biz.crm.mdm.business.price.management.sdk.vo;

import lombok.Data;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年06月09日 14:18:00
 */
@Data
@CrmExcelImport(startRow = 1)
public class PriceDirectDataImportsVo extends CrmExcelVo {
    @CrmExcelColumn(value = "定价记录号", order = 0)
    private String pricingRecordNumber;

    @CrmExcelColumn(value = "价格类型编码", order = 1)
    private String priceFormCode;


    @CrmExcelColumn(value = "价格类型名称", order = 3)
    private String priceFormName;


    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @CrmExcelColumn(value = "数据来源[数据字典:pricing_dimension]", order = 4)
    private String pricingDimension;

    @CrmExcelColumn(value = "商品编码", order = 5)
    private String goodsCode;

    @CrmExcelColumn(value = "商品名称", order = 6)
    private String goodsName;

    @CrmExcelColumn(value = "价格", order = 7)
    private BigDecimal price;

    @CrmExcelColumn(value = "生效状态", order = 10)
    private String validState;

    @CrmExcelColumn(value = "组织", order = 10)
    private String organization;

}
