package com.biz.crm.mdm.business.price.management.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * (PriceDirectDataVo)
 *
 * @author makejava
 * @since 2022-11-19 11:26:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PriceDirectData", description = "价格管理主数据置表")
public class PriceDirectDataVo extends TenantFlagOpVo {

    /**
     * 定价记录号
     */
    @ApiModelProperty("定价记录号")
    private String pricingRecordNumber;

    /**
     * 价格类型编码
     */
    @ApiModelProperty("价格类型编码")
    private String priceFormCode;


    /**
     * 价格类型名称
     */
    @ApiModelProperty("价格类型名称")
    private String priceFormName;

    /**
     * 定价维度
     */
    @ApiModelProperty("定价维度")
    private String pricingDimension;


    /**
     * 商品编码
     */
    @ApiModelProperty("商品编码")
    private String goodsCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String goodsName;

    /**
     * 价格
     */
    @ApiModelProperty("价格")
    private BigDecimal price;


    /**
     * 有效开始时间
     */
    @ApiModelProperty(name = "有效开始时间", notes = "有效开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;
    /**
     * 有效结束时间
     */
    @ApiModelProperty(name = "有效结束时间", notes = "有效结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 生效状态
     */
    @ApiModelProperty("生效状态")
    private String validState;

    /**
     * 组织
     */
    @ApiModelProperty("组织")
    private String organization;

    /**
     * 客户
     */
    @ApiModelProperty("客户")
    private String client;


}
