/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.form.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.form.local.entity.ProductFormEntity;
import com.biz.crm.mdm.business.product.form.local.repository.ProductFormRepository;
import com.biz.crm.mdm.business.product.form.sdk.dto.ProductFormDto;
import com.biz.crm.mdm.business.product.form.sdk.dto.QueryProductFormDto;
import com.biz.crm.mdm.business.product.form.sdk.service.ProductFormService;
import com.biz.crm.mdm.business.product.form.sdk.vo.ProductFormDetailVo;
import com.biz.crm.mdm.business.product.form.sdk.vo.ProductFormVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="productFormService")
public class ProductFormServiceImpl
implements ProductFormService {
    private static final Logger log = LoggerFactory.getLogger(ProductFormServiceImpl.class);
    @Autowired
    private ProductFormRepository productFormRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public ProductFormVo searchByProductForm(QueryProductFormDto dto) {
        return this.productFormRepository.searchByProductForm(dto);
    }

    public Page<ProductFormVo> findByConditions(Pageable pageable, ProductFormDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProductFormDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.productFormRepository.findByConditions(pageable, dto);
    }

    public ProductFormVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProductFormEntity productBrand = (ProductFormEntity)((Object)this.productFormRepository.getById((Serializable)((Object)id)));
        if (null == productBrand) {
            return null;
        }
        return (ProductFormVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productBrand, ProductFormVo.class, null, null, new String[0]);
    }

    public Page<ProductFormDetailVo> findByDetail(Pageable pageable, ProductFormDto productFormDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(productFormDto)) {
            productFormDto = new ProductFormDto();
        }
        return this.productFormRepository.findByDetail(pageable, productFormDto);
    }
}

