package com.biz.crm.mdm.business.product.form.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.form.sdk.dto.ProductFormDto;
import com.biz.crm.mdm.business.product.form.sdk.dto.QueryProductFormDto;
import com.biz.crm.mdm.business.product.form.sdk.vo.ProductFormDetailVo;
import com.biz.crm.mdm.business.product.form.sdk.vo.ProductFormVo;
import org.springframework.data.domain.Pageable;

/**
 * (ProductFormService)service实现类
 * @author makejava
 * @since 2022-11-14 17:14:14
 */
public interface ProductFormService {

    /**
     * 搜索功能主数据功能
     * @param dto 查询实体
     * @return 所有数据
     */
    ProductFormVo searchByProductForm(QueryProductFormDto dto);

    /**
     * 分页查询所有数据
     *
     * @param pageable       分页对象
     * @param productFormDto 查询dto
     * @return 所有数据
     */
    Page<ProductFormVo> findByConditions(Pageable pageable, ProductFormDto productFormDto);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    ProductFormVo findById(String id);
    /**
     * 根据条件分页查询所有数据
     *
     * @param pageable       分页对象
     * @param productFormDto 查询dto
     * @return 所有数据
     */
    Page<ProductFormDetailVo> findByDetail(Pageable pageable, ProductFormDto productFormDto);
}
