package com.biz.crm.mdm.business.product.form.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * (ProductFormDto)
 *
 * @author heding
 * @since 2022-12-09 15:19:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ProductFormDetailVo", description = "产品类型详情")
public class ProductFormDetailVo extends TenantFlagOpVo {
    /**
     * 产品品项编码
     */
    @ApiModelProperty("产品品项编码")
    private String productItemCode;

    /**
     * 产品品项名称
     */
    @ApiModelProperty("产品品项名称")
    private String productItemName;


    /**
     * 所属产品品类编码
     */
    @ApiModelProperty("所属产品品类编码")
    private String productCategoryCode;


    /**
     * 所属产品品类名称
     */
    @ApiModelProperty("所属产品品类名称")
    private String productCategoryName;
    /**
     * 产品范围
     */
    @ApiModelProperty(name = "产品范围", notes = "产品范围")
    private List<TpmProductRangeVo> productRangeVoList;
}
