package com.biz.crm.mdm.business.product.form.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * (TpmProductRangeVo)
 * @author heding
 * @since 2022-12-09 15:19:51
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmProductRangeVo", description = "产品范围")
public class TpmProductRangeVo extends TenantFlagOpVo {

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
    private String productCode;


    /**
     * 产品名字
     */
    @ApiModelProperty("产品名字")
    @Column(name = "product_name", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '产品名字'")
    private String productName;

    /**
     * 品牌
     */
    @ApiModelProperty("产品品牌")
    @Column(name = "brand", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '品牌'")
    private String productBrandName;


    /**
     * 产品品类
     */
    @ApiModelProperty("产品品类")
    @Column(name = "product_category", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '产品品类'")
    private String productCategoryName;

    /**
     * 产品品项
     */
    @ApiModelProperty("产品品项")
    @Column(name = "product_item", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '产品品项'")
    private String productItemName;

    /**
     * 产品品类编码
     */
    @ApiModelProperty("产品品类编码")
    @Column(name = "product_category_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '产品品类编码'")
    private String productCategoryCode;


    /**
     * 产品品项编码
     */
    @ApiModelProperty("产品品项编码")
    @Column(name = "product_item_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '产品品项编码'")
    private String productItemCode;


}