package com.biz.crm.mdm.business.material.unit.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.mdm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author jerry7
 * @date 2021/10/26 16:24
 * 物料单位实体类
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialUnit", description = "物料单位实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`material_unit`", comment = "物料单位实体类")
@TableName("material_unit")
@Table(name = "`material_unit`", indexes = @Index(name = "MaterialUnit", columnList = "unit_code", unique = true))
public class MaterialUnit extends TenantFlagOpEntity {

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位编码")
  @Column(name = "unit_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料单位编码 '")
  private String unitCode;

  /**
   * 物料单位名称
   */
  @ApiModelProperty("物料单位名称")
  @Column(name = "unit_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料单位名称 '")
  private String unitName;
}
