/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.common.local.service.internal;

import com.biz.crm.mdm.business.common.sdk.dto.TreeDto;
import com.biz.crm.mdm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.mdm.business.common.sdk.utils.TreeRuleCode;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service(value="defaultTreeRuleCodeStrategy")
public class DefaultTreeGenerateRuleCodeServiceImpl
implements TreeRuleCodeStrategy {
    private static final String KEY = "default";
    private Map<Integer, TreeRuleCode> cache = new HashMap<Integer, TreeRuleCode>();

    private TreeRuleCode get(int ruleCodeSplitLength) {
        TreeRuleCode treeRuleCode = this.cache.get(ruleCodeSplitLength);
        if (treeRuleCode != null) {
            return treeRuleCode;
        }
        treeRuleCode = new TreeRuleCode(ruleCodeSplitLength);
        this.cache.put(ruleCodeSplitLength, treeRuleCode);
        return treeRuleCode;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String generate(int ruleCodeSplitLength, String parentRuleCode, List<TreeDto> children) {
        String ruleCode = "";
        String prefix = "";
        TreeRuleCode treeRuleCode = this.get(ruleCodeSplitLength);
        if (StringUtils.isNotEmpty((CharSequence)parentRuleCode)) {
            prefix = parentRuleCode;
        }
        if (CollectionUtils.isEmpty(children)) {
            ruleCode = prefix + treeRuleCode.generateByNum(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (TreeDto item : children) {
                if (!StringUtils.isNotEmpty((CharSequence)item.getRuleCode())) continue;
                Integer integer = treeRuleCode.findLevelNumByRuleCode(item.getRuleCode());
                set.add(integer);
            }
            int maxRuleCodeValueInLevel = treeRuleCode.getMaxRuleCode();
            for (int i = 1; i <= maxRuleCodeValueInLevel; ++i) {
                Validate.isTrue((i != maxRuleCodeValueInLevel ? 1 : 0) != 0, (String)"\u964d\u7ef4\u7f16\u7801\u8d8a\u754c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (Object[])new Object[0]);
                if (set.contains(i)) continue;
                ruleCode = prefix + treeRuleCode.generateByNum(i);
                break;
            }
        }
        return ruleCode;
    }

    @Override
    public String generateByNum(int ruleCodeSplitLength, int num) {
        TreeRuleCode treeRuleCode = this.get(ruleCodeSplitLength);
        return treeRuleCode.generateByNum(num);
    }

    @Override
    public Set<String> findParentRuleCodeByRuleCodesExcludeAnySelf(int ruleCodeSplitLength, List<String> ruleCodes) {
        TreeRuleCode treeRuleCode = this.get(ruleCodeSplitLength);
        return treeRuleCode.findParentRuleCodesByRuleCodesExcludeAnySelf(ruleCodes);
    }

    @Override
    public Set<String> findParentRuleCodesByRuleCodeExcludeSelf(int ruleCodeSplitLength, String ruleCode) {
        TreeRuleCode treeRuleCode = this.get(ruleCodeSplitLength);
        return treeRuleCode.findParentRuleCodesByRuleCodeExcludeSelf(ruleCode);
    }

    @Override
    public Set<String> findParentRuleCodesByRuleCodesExcludeSelf(int ruleCodeSplitLength, List<String> ruleCodes) {
        TreeRuleCode treeRuleCode = this.get(ruleCodeSplitLength);
        return treeRuleCode.findParentRuleCodesByRuleCodesExcludeSelf(ruleCodes);
    }

    @Override
    public Set<String> findParentRuleCodeByRuleCode(int ruleCodeSplitLength, String ruleCode) {
        TreeRuleCode treeRuleCode = this.get(ruleCodeSplitLength);
        return treeRuleCode.findParentRuleCodesByRuleCode(ruleCode);
    }

    @Override
    public Set<String> findParentRuleCodeByRuleCodes(int ruleCodeSplitLength, List<String> ruleCodes) {
        TreeRuleCode treeRuleCode = this.get(ruleCodeSplitLength);
        return treeRuleCode.findParentRuleCodesByRuleCodes(ruleCodes);
    }
}

