/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.common.sdk.utils;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeRuleCode {
    private static final Logger log = LoggerFactory.getLogger(TreeRuleCode.class);
    private int ruleCodeSplitLength = 3;

    public TreeRuleCode(int ruleCodeSplitLength) {
        this.ruleCodeSplitLength = ruleCodeSplitLength;
    }

    public String generateByNum(Integer num) {
        int length = this.getRuleCodeSplitLength();
        return String.format("%0" + length + "d", num);
    }

    public Set<String> findParentRuleCodesByRuleCode(String ruleCode) {
        int length = this.getRuleCodeSplitLength();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)ruleCode)) {
            set.add(ruleCode);
            while (ruleCode.length() > length) {
                ruleCode = ruleCode.substring(0, ruleCode.length() - length);
                set.add(ruleCode);
            }
        }
        return set;
    }

    public Set<String> findParentRuleCodesByRuleCodes(List<String> ruleCodeList) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String ruleCode : ruleCodeList) {
            set.addAll(this.findParentRuleCodesByRuleCode(ruleCode));
        }
        return set;
    }

    public Set<String> findParentRuleCodesByRuleCodeExcludeSelf(String ruleCode) {
        int length = this.getRuleCodeSplitLength();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)ruleCode)) {
            while (ruleCode.length() > length) {
                ruleCode = ruleCode.substring(0, ruleCode.length() - length);
                set.add(ruleCode);
            }
        }
        return set;
    }

    public Set<String> findParentRuleCodesByRuleCodesExcludeSelf(List<String> ruleCodeList) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(ruleCodeList)) {
            for (String ruleCode : ruleCodeList) {
                set.addAll(this.findParentRuleCodesByRuleCodeExcludeSelf(ruleCode));
            }
        }
        return set;
    }

    public Set<String> findParentRuleCodesByRuleCodesExcludeAnySelf(List<String> ruleCodeList) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(ruleCodeList)) {
            HashSet<String> collect = new HashSet<String>(ruleCodeList);
            for (String ruleCode : collect) {
                set.addAll(this.findParentRuleCodesByRuleCodeExcludeSelf(ruleCode));
            }
            return set.stream().filter(item -> !collect.contains(item)).collect(Collectors.toSet());
        }
        return set;
    }

    public int findLevelNumByRuleCode(String ruleCode) {
        int length = this.getRuleCodeSplitLength();
        if (StringUtils.isNotBlank((CharSequence)ruleCode) && ruleCode.length() >= length) {
            try {
                if (ruleCode.length() % length != 0) {
                    throw new RuntimeException();
                }
                return Integer.valueOf(ruleCode.substring(ruleCode.length() - length));
            }
            catch (Exception e) {
                throw new RuntimeException("\u5b58\u5728\u4e0d\u89c4\u8303\u7684\u964d\u7ef4\u7f16\u7801,\u6216\u8005\u7f16\u7801\u89c4\u5219\u5df2\u53d8\u66f4\uff0c\u8bf7\u5148\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
            }
        }
        return 0;
    }

    public int getRuleCodeSplitLength() {
        return this.ruleCodeSplitLength;
    }

    public int getMaxRuleCode() {
        int ruleCodeSplitLength = this.getRuleCodeSplitLength();
        int max = 1;
        for (int i = 1; i <= ruleCodeSplitLength; ++i) {
            max *= 10;
        }
        return max - 1;
    }
}

