package com.biz.crm.mdm.business.format.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.format.local.entity.BusinessFormat;
import com.biz.crm.mdm.business.format.local.service.BusinessFormatService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.format.sdk.dto.BusinessFormatQueryPaginationDto;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestParam;


import java.util.List;
import java.util.Optional;

/**
 * 业态主表实体(BusinessFormat)表相关的http接口
 *
 * @author makejava
 * @since 2023-02-24 17:33:20
 */
@RestController
@RequestMapping("/v1/businessFormat/businessFormat")
@Slf4j
@Api(tags = "业态主表实体：BusinessFormat：业态主表实体")
public class BusinessFormatController {
  /**
   * 服务对象
   */
  @Autowired
  private BusinessFormatService businessFormatService;


  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<BusinessFormat>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                BusinessFormatQueryPaginationDto paginationDto) {
    try {
      paginationDto = Optional.ofNullable(paginationDto).orElse(new BusinessFormatQueryPaginationDto());
      paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      Page<BusinessFormat> result = this.businessFormatService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 产品品牌下拉
   *
   * @param dto 产品品牌查询参数
   * @return 下拉数据
   */
  @ApiOperation(value = "产品业态下拉")
  @PostMapping("findFormatTypeSelectList")
  public Result<List<CommonSelectVo>> findFormatTypeSelectList(@ApiParam(value = "产品品牌下拉参数dto") @RequestBody CommonSelectDto dto) {
    try {
      List<CommonSelectVo> list = businessFormatService.findBrandFormSelectList(dto);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<BusinessFormat> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      BusinessFormat businessFormat = this.businessFormatService.findById(id);
      return Result.ok(businessFormat);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param businessFormat 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<BusinessFormat> create(@ApiParam(name = "businessFormat", value = "业态主表实体") @RequestBody BusinessFormat businessFormat) {
    try {
      BusinessFormat result = this.businessFormatService.create(businessFormat);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param businessFormat 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<BusinessFormat> update(@ApiParam(name = "businessFormat", value = "业态主表实体") @RequestBody BusinessFormat businessFormat) {
    try {
      BusinessFormat result = this.businessFormatService.update(businessFormat);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.businessFormatService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.businessFormatService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.businessFormatService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
