package com.biz.crm.mdm.business.format.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 商品主表实体
 *
 * @author liangxin
 * @date 2023/2/24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_business_format")
@Api(tags = "业态主表实体")
@Table(name = "mdm_business_format")
@org.hibernate.annotations.Table(appliesTo = "mdm_business_format", comment = "业态主表实体")
public class BusinessFormat extends UuidFlagOpEntity {
  private static final long serialVersionUID = 4213480266009166371L;

  @ApiModelProperty("业态编码")
  @TableField(value = "business_format_code")
  @Column(name = "business_format_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态编码'")
  private String businessFormatCode;

  @ApiModelProperty("业态名称")
  @TableField(value = "business_format_name")
  @Column(name = "business_format_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态名称'")
  private String businessFormatName;

  @ApiModelProperty("数据来源")
  @TableField(value = "source")
  @Column(name = "source", length = 64, columnDefinition = "VARCHAR(64) COMMENT '数据来源'")
  private String source;
}
