package com.biz.crm.mdm.business.format.local.repository;



import com.biz.crm.mdm.business.format.local.entity.BusinessFormat;
import com.biz.crm.mdm.business.format.local.mapper.BusinessFormatMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;

/**
 * 业态主表实体(BusinessFormat)表数据库访问层
 *
 * @author makejava
 * @since 2023-02-24 17:33:21
 */
@Component
public class BusinessFormatRepository extends ServiceImpl<BusinessFormatMapper, BusinessFormat> {

  /**
   * 根据id集合查询数据
   *
   * @param idList id集合
   * @return
   */
  public List<BusinessFormat> findByIds(List<String> idList) {
    return this.lambdaQuery()
        .eq(BusinessFormat::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(BusinessFormat::getId, idList)
        .list();
  }
  
  /**
   * 根据id集合和启禁用状态查询数据
   *
   * @param statusEnum 启禁用状态
   * @param idList     id集合
   * @return
   */
  public List<BusinessFormat> findEnableStatusByIds(EnableStatusEnum statusEnum, List<String> idList) {
    return this.lambdaQuery()
        .eq(BusinessFormat::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(BusinessFormat::getEnableStatus, statusEnum.getCode())
        .in(BusinessFormat::getId, idList)
        .list();
  }

  public List<BusinessFormat> findByBusinessFormatName(String businessFormatName) {
    return this.lambdaQuery()
            .eq(BusinessFormat::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .in(BusinessFormat::getBusinessFormatName, businessFormatName)
            .list();
  }
}

