package com.biz.crm.mdm.business.format.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.format.local.entity.BusinessFormat;
import com.biz.crm.mdm.business.format.sdk.dto.BusinessFormatQueryPaginationDto;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 业态主表实体(BusinessFormat)表服务接口
 *
 * @author makejava
 * @since 2023-02-24 17:33:20
 */
public interface BusinessFormatService{
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  BusinessFormat findById(String id);
  
   /**
   * 新增数据
   * @param businessFormat 实体对象
   * @return 新增结果
   */
  BusinessFormat create(BusinessFormat businessFormat);
  
   /**
   * 修改新据
   * @param businessFormat 实体对象
   * @return 修改结果
   */
  BusinessFormat update(BusinessFormat businessFormat);
  
  /**
   * 逻辑删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);
  
  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);
  
  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<BusinessFormat> findByConditions(Pageable pageable, BusinessFormatQueryPaginationDto paginationDto);

  /**
   * 获取业态下拉
   *
   * @param dto
   * @return
   */
  List<CommonSelectVo> findBrandFormSelectList(CommonSelectDto dto);

}

