package com.biz.crm.mdm.business.format.local.service.internal;

import com.biz.crm.mdm.business.format.local.entity.BusinessFormat;
import com.biz.crm.mdm.business.format.local.repository.BusinessFormatRepository;
import com.biz.crm.mdm.business.format.sdk.service.BusinessFormatVoService;
import com.biz.crm.mdm.business.format.sdk.vo.BusinessFormatVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author ldx
 * @Date 2023/03/22 10:57
 **/
@Service("businessFormatVoService")
public class BusinessFormatVoServiceImpl implements BusinessFormatVoService {

  @Autowired
  private BusinessFormatRepository businessFormatRepository;


  @Override
  public BusinessFormatVo findByBusinessFormatName(String businessFormatName) {
    List<BusinessFormat> formats = businessFormatRepository.findByBusinessFormatName(businessFormatName);
    BusinessFormatVo vo = new BusinessFormatVo();
    if(CollectionUtils.isNotEmpty(formats)){
      BeanUtils.copyProperties(formats.get(0),vo);
    }
    return vo;
  }
}
