/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.format.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.format.local.entity.BusinessFormat;
import com.biz.crm.mdm.business.format.local.repository.BusinessFormatRepository;
import com.biz.crm.mdm.business.format.local.service.BusinessFormatService;
import com.biz.crm.mdm.business.format.sdk.dto.BusinessFormatQueryPaginationDto;
import com.biz.crm.mdm.business.format.sdk.enums.DataSourceEnum;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="businessFormatService")
public class BusinessFormatServiceImpl
implements BusinessFormatService {
    @Autowired
    private BusinessFormatRepository businessFormatRepository;

    @Override
    public BusinessFormat findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (BusinessFormat)((Object)this.businessFormatRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public BusinessFormat create(BusinessFormat businessFormat) {
        this.createValidate(businessFormat);
        this.businessFormatRepository.saveOrUpdate((Object)businessFormat);
        return businessFormat;
    }

    @Override
    @Transactional
    public BusinessFormat update(BusinessFormat businessFormat) {
        this.updateValidate(businessFormat);
        this.businessFormatRepository.saveOrUpdate((Object)businessFormat);
        return businessFormat;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<BusinessFormat> businessFormats = this.businessFormatRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(businessFormats) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        businessFormats.stream().forEach(businessFormat -> businessFormat.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.businessFormatRepository.saveOrUpdateBatch(businessFormats);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<BusinessFormat> businessFormats = this.businessFormatRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        if (CollectionUtils.isEmpty(businessFormats)) {
            return;
        }
        businessFormats.stream().forEach(businessFormat -> businessFormat.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.businessFormatRepository.saveOrUpdateBatch(businessFormats);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<BusinessFormat> businessFormats = this.businessFormatRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        if (CollectionUtils.isEmpty(businessFormats)) {
            return;
        }
        businessFormats.stream().forEach(businessFormat -> businessFormat.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.businessFormatRepository.saveOrUpdateBatch(businessFormats);
    }

    @Override
    public Page<BusinessFormat> findByConditions(Pageable pageable, BusinessFormatQueryPaginationDto paginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return (Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.businessFormatRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)paginationDto.getDelFlag())).like(StringUtils.isNotBlank((CharSequence)paginationDto.getBusinessFormatName()), BusinessFormat::getBusinessFormatName, (Object)paginationDto.getBusinessFormatName())).like(StringUtils.isNotBlank((CharSequence)paginationDto.getBusinessFormatCode()), BusinessFormat::getBusinessFormatCode, (Object)paginationDto.getBusinessFormatCode())).eq(StringUtils.isNotBlank((CharSequence)paginationDto.getEnableStatus()), UuidFlagOpEntity::getEnableStatus, (Object)paginationDto.getEnableStatus())).eq(StringUtils.isNotBlank((CharSequence)paginationDto.getSource()), BusinessFormat::getSource, (Object)paginationDto.getSource())).like(StringUtils.isNotBlank((CharSequence)paginationDto.getModifyName()), UuidOpEntity::getModifyName, (Object)paginationDto.getModifyName())).ge(paginationDto.getModifyStartTime() != null, UuidOpEntity::getModifyTime, (Object)paginationDto.getModifyStartTime())).le(paginationDto.getModifyEndTime() != null, UuidOpEntity::getModifyTime, (Object)paginationDto.getModifyEndTime())).page((IPage)page);
    }

    @Override
    public List<CommonSelectVo> findBrandFormSelectList(CommonSelectDto dto) {
        List list;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtils.isNotEmpty((Object)dto)) {
            if (StringUtils.isNotBlank((CharSequence)dto.getCodeOrName())) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(BusinessFormat::getBusinessFormatName, (Object)dto.getCodeOrName())).or()).like(BusinessFormat::getBusinessFormatCode, (Object)dto.getCodeOrName());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getSelectedCode())) {
                queryWrapper.lambda().ne(BusinessFormat::getBusinessFormatCode, (Object)dto.getSelectedCode());
            }
            if (!CollectionUtils.isEmpty((Collection)dto.getSelectedCodeList())) {
                queryWrapper.lambda().notIn(BusinessFormat::getBusinessFormatCode, (Collection)dto.getSelectedCodeList());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.businessFormatRepository.list((Wrapper)queryWrapper)))) {
            return null;
        }
        return list.stream().map(s -> {
            CommonSelectVo vo = new CommonSelectVo();
            vo.setValue(s.getBusinessFormatName());
            vo.setCode(s.getBusinessFormatCode());
            return vo;
        }).collect(Collectors.toList());
    }

    private void createValidate(BusinessFormat businessFormat) {
        Validate.notNull((Object)((Object)businessFormat), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)businessFormat.getBusinessFormatName(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u6001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BusinessFormat one = (BusinessFormat)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.businessFormatRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(BusinessFormat::getBusinessFormatName, (Object)businessFormat.getBusinessFormatName())).one());
        Validate.isTrue((one == null ? 1 : 0) != 0, (String)"\u4e1a\u6001\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        businessFormat.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        businessFormat.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        businessFormat.setSource(DataSourceEnum.SELF_CREATE_SOURCE.getCode());
        businessFormat.setId(null);
    }

    private void updateValidate(BusinessFormat businessFormat) {
        Validate.notNull((Object)((Object)businessFormat), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessFormat.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)businessFormat.getBusinessFormatName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BusinessFormat one = (BusinessFormat)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.businessFormatRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(BusinessFormat::getBusinessFormatName, (Object)businessFormat.getBusinessFormatName().trim())).ne(UuidEntity::getId, (Object)businessFormat.getId())).one());
        Validate.isTrue((one == null ? 1 : 0) != 0, (String)"\u4e1a\u6001\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        businessFormat.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        businessFormat.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        businessFormat.setSource(DataSourceEnum.SELF_CREATE_SOURCE.getCode());
    }
}

