package com.biz.crm.mdm.business.product.unit.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.unit.local.entity.MdmUnitEntity;
import com.biz.crm.mdm.business.product.unit.local.service.UnitService;
import com.biz.crm.mdm.business.product.unit.sdk.dto.UnitPaginationQueryDto;
import com.biz.crm.mdm.business.product.unit.sdk.service.UnitVoService;
import com.biz.crm.mdm.business.product.unit.sdk.vo.ProductLevelUnitVo;
import com.biz.crm.mdm.business.product.unit.sdk.vo.UnitVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

/**
 * 单位表(Unit)表相关的http接口
 *
 * @author makejava
 * @since 2023-03-01 14:49:23
 */
@RestController
@RequestMapping("/v1/unit/unit")
@Slf4j
@Api(tags = "单位表：MdmUnitEntity：单位表")
public class UnitController {
  /**
  * 服务对象
  */
  @Autowired
  private UnitService unitService;

  /**
   * 服务对象
   */
  @Autowired
  private UnitVoService unitVoService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<MdmUnitEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                      UnitPaginationQueryDto paginationDto) {
    try {
      paginationDto = Optional.ofNullable(paginationDto).orElse(new UnitPaginationQueryDto());
      paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      Page<MdmUnitEntity> result = this.unitService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<MdmUnitEntity> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      MdmUnitEntity unit = this.unitService.findById(id);
      return Result.ok(unit);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param unit 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<MdmUnitEntity> create(@ApiParam(name = "unit", value = "单位表") @RequestBody MdmUnitEntity unit) {
    try {
      MdmUnitEntity result = this.unitService.create(unit);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param unit 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<MdmUnitEntity> update(@ApiParam(name = "unit", value = "单位表") @RequestBody MdmUnitEntity unit) {
    try {
      MdmUnitEntity result = this.unitService.update(unit);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.unitService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.unitService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.unitService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @GetMapping("getByProductLevelCode")
  @ApiOperation(value = "通过产品层级获取编码")
  public Result<List<UnitVo>> getByProductLevelCode(@RequestParam("code")String code) {
    try {
      List<UnitVo> vos = this.unitVoService.getByProductLevelCode(code);
      return Result.ok(vos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @GetMapping("getByProductLevelCodes")
  @ApiOperation(value = "通过产品层级获取编码")
  public Result<List<ProductLevelUnitVo>> getByProductLevelCodes(@RequestParam("codes")List<String> codes) {
    try {
      List<ProductLevelUnitVo> vos = this.unitVoService.getByProductLevelCodes(codes);
      return Result.ok(vos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
