package com.biz.crm.mdm.business.product.unit.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_unit")
@Api(tags = "单位表实体")
@Table(name = "mdm_unit")
@org.hibernate.annotations.Table(appliesTo = "mdm_unit", comment = "单位表")
public class MdmUnitEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 6149200564814919858L;

  @ApiModelProperty("单位编码")
  @TableField(value = "unit_code")
  @Column(name = "unit_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '单位编码'")
  private String unitCode;

  @ApiModelProperty("单位名称")
  @TableField(value = "unit_name")
  @Column(name = "unit_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位名称'")
  private String unitName;

  @ApiModelProperty("数据来源")
  @TableField(value = "source")
  @Column(name = "source", length = 64, columnDefinition = "VARCHAR(64) default '0' COMMENT '数据来源'")
  private String source;
}
