package com.biz.crm.mdm.business.product.unit.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.unit.local.entity.MdmUnitEntity;
import com.biz.crm.mdm.business.product.unit.local.mapper.UnitMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 单位表(Unit)表数据库访问层
 *
 * @author makejava
 * @since 2023-03-01 14:49:24
 */
@Component
public class UnitRepository extends ServiceImpl<UnitMapper, MdmUnitEntity> {

  /**
   * 根据id集合查询数据
   *
   * @param idList id集合
   * @return
   */
  public List<MdmUnitEntity> findByIds(List<String> idList) {
    return this.lambdaQuery().eq(MdmUnitEntity::getTenantCode, TenantUtils.getTenantCode())
        .eq(MdmUnitEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(MdmUnitEntity::getId, idList)
        .list();
  }
  
  /**
   * 根据id集合和启禁用状态查询数据
   *
   * @param statusEnum 启禁用状态
   * @param idList     id集合
   * @return
   */
  public List<MdmUnitEntity> findEnableStatusByIds(EnableStatusEnum statusEnum, List<String> idList) {
    return this.lambdaQuery().eq(MdmUnitEntity::getTenantCode, TenantUtils.getTenantCode())
        .eq(MdmUnitEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(MdmUnitEntity::getEnableStatus, statusEnum.getCode())
        .in(MdmUnitEntity::getId, idList)
        .list();
  }
}

