package com.biz.crm.mdm.business.product.unit.local.service;



import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.unit.local.entity.MdmUnitEntity;
import com.biz.crm.mdm.business.product.unit.sdk.dto.UnitPaginationQueryDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 单位表(MdmUnitEntity)表服务接口
 *
 * @author makejava
 * @since 2023-03-01 14:49:24
 */
public interface UnitService{
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  MdmUnitEntity findById(String id);
  
   /**
   * 新增数据
   * @param MdmUnitEntity 实体对象
   * @return 新增结果
   */
  MdmUnitEntity create(MdmUnitEntity MdmUnitEntity);
  
   /**
   * 修改新据
   * @param MdmUnitEntity 实体对象
   * @return 修改结果
   */
  MdmUnitEntity update(MdmUnitEntity MdmUnitEntity);
  
  /**
   * 逻辑删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);
  
  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);
  
  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<MdmUnitEntity> findByConditions(Pageable pageable, UnitPaginationQueryDto paginationDto);


  List<MdmUnitEntity> getByCodes(List<String> codes);

}

