package com.biz.crm.mdm.business.product.unit.local.service.internal;

import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductUnitVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.unit.local.entity.MdmUnitEntity;
import com.biz.crm.mdm.business.product.unit.local.service.UnitService;
import com.biz.crm.mdm.business.product.unit.sdk.service.UnitVoService;
import com.biz.crm.mdm.business.product.unit.sdk.vo.ProductLevelUnitVo;
import com.biz.crm.mdm.business.product.unit.sdk.vo.UnitVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.net.PortUnreachableException;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional
public class UnitVoServiceImpl implements UnitVoService {

  @Autowired
  UnitService service;

  @Autowired
  NebulaToolkitService nebulaToolkitService;

  @Autowired
  ProductVoService productVoService;

  @Override
  public List<UnitVo> getByCodes(List<String> codes) {
    List<MdmUnitEntity> entities = service.getByCodes(codes);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    return entities.stream().map(s -> {
      UnitVo vo = new UnitVo();
      BeanUtils.copyProperties(s, vo);
      return vo;
    }).collect(Collectors.toList());
  }

  @Override
  public List<UnitVo> getByProductLevelCode(String code) {
    if (StringUtils.isBlank(code)) {
      return null;
    }
    List<ProductVo> productVos = productVoService.findByProductLevelCodes(Collections.singletonList(code));
    if (CollectionUtils.isEmpty(productVos)) {
      return null;
    }
    List<ProductUnitVo> collect = new ArrayList<>();
    for (ProductVo s : productVos) {
      if (CollectionUtils.isNotEmpty(s.getUnitList())) {
        collect.addAll(s.getUnitList());
      }
    }
    if (CollectionUtils.isEmpty(collect)) {
      return null;
    }
    return getByCodes(collect.stream().map(ProductUnitVo::getUnitCode).distinct().collect(Collectors.toList()));
  }

  @Override
  public List<ProductLevelUnitVo> getByProductLevelCodes(List<String> codes) {
    if (CollectionUtils.isEmpty(codes)) {
      return null;
    }
    List<ProductVo> productVos = productVoService.findByProductLevelCodes(codes);
    if (CollectionUtils.isEmpty(productVos)) {
      return null;
    }
    List<ProductLevelUnitVo> vos = new ArrayList<>();
    Map<String, List<ProductVo>> map = productVos.stream()
            .collect(Collectors.groupingBy(ProductVo::getProductLevelCode));
    for (Map.Entry<String, List<ProductVo>> entry : map.entrySet()) {
      ProductLevelUnitVo vo = new ProductLevelUnitVo();
      vo.setProductLevelCode(entry.getKey());
      List<ProductVo> value = entry.getValue();
      List<ProductUnitVo> unitVos = new ArrayList<>();
      for (ProductVo s : value) {
        if (CollectionUtils.isNotEmpty(s.getUnitList())) {
          unitVos.addAll(s.getUnitList());
        }
      }
      if (CollectionUtils.isEmpty(unitVos)) {
        vo.setUnitVoList(null);
      } else {
        vo.setUnitVoList(getByCodes(unitVos.stream()
                .map(ProductUnitVo::getUnitCode).distinct().collect(Collectors.toList())));
      }
      vos.add(vo);
    }
    return vos;
  }
}
