/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.unit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.unit.local.entity.MdmUnitEntity;
import com.biz.crm.mdm.business.product.unit.local.service.UnitService;
import com.biz.crm.mdm.business.product.unit.sdk.dto.UnitPaginationQueryDto;
import com.biz.crm.mdm.business.product.unit.sdk.service.UnitVoService;
import com.biz.crm.mdm.business.product.unit.sdk.vo.ProductLevelUnitVo;
import com.biz.crm.mdm.business.product.unit.sdk.vo.UnitVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/unit/unit"})
@Api(tags={"\u5355\u4f4d\u8868\uff1aMdmUnitEntity\uff1a\u5355\u4f4d\u8868"})
public class UnitController {
    private static final Logger log = LoggerFactory.getLogger(UnitController.class);
    @Autowired
    private UnitService unitService;
    @Autowired
    private UnitVoService unitVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<MdmUnitEntity>> findByConditions(@PageableDefault(value=50) Pageable pageable, UnitPaginationQueryDto paginationDto) {
        try {
            paginationDto = Optional.ofNullable(paginationDto).orElse(new UnitPaginationQueryDto());
            paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page<MdmUnitEntity> result = this.unitService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<MdmUnitEntity> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            MdmUnitEntity unit = this.unitService.findById(id);
            return Result.ok((Object)((Object)unit));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<MdmUnitEntity> create(@ApiParam(name="unit", value="\u5355\u4f4d\u8868") @RequestBody MdmUnitEntity unit) {
        try {
            MdmUnitEntity result = this.unitService.create(unit);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<MdmUnitEntity> update(@ApiParam(name="unit", value="\u5355\u4f4d\u8868") @RequestBody MdmUnitEntity unit) {
        try {
            MdmUnitEntity result = this.unitService.update(unit);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.unitService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.unitService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.unitService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"getByProductLevelCode"})
    @ApiOperation(value="\u901a\u8fc7\u4ea7\u54c1\u5c42\u7ea7\u83b7\u53d6\u7f16\u7801")
    public Result<List<UnitVo>> getByProductLevelCode(@RequestParam(value="code") String code) {
        try {
            List vos = this.unitVoService.getByProductLevelCode(code);
            return Result.ok((Object)vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"getByProductLevelCodes"})
    @ApiOperation(value="\u901a\u8fc7\u4ea7\u54c1\u5c42\u7ea7\u83b7\u53d6\u7f16\u7801")
    public Result<List<ProductLevelUnitVo>> getByProductLevelCodes(@RequestParam(value="codes") List<String> codes) {
        try {
            List vos = this.unitVoService.getByProductLevelCodes(codes);
            return Result.ok((Object)vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

