/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.unit.local.service.internal;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.unit.local.entity.MdmUnitEntity;
import com.biz.crm.mdm.business.product.unit.local.repository.UnitRepository;
import com.biz.crm.mdm.business.product.unit.local.service.UnitService;
import com.biz.crm.mdm.business.product.unit.sdk.dto.UnitPaginationQueryDto;
import com.biz.crm.mdm.business.product.unit.sdk.enums.DataSourceEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="unitService")
public class UnitServiceImpl
implements UnitService {
    @Autowired
    private UnitRepository unitRepository;

    @Override
    public MdmUnitEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (MdmUnitEntity)((Object)this.unitRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public MdmUnitEntity create(MdmUnitEntity unit) {
        this.createValidate(unit);
        this.unitRepository.saveOrUpdate((Object)unit);
        return unit;
    }

    @Override
    @Transactional
    public MdmUnitEntity update(MdmUnitEntity unit) {
        this.updateValidate(unit);
        this.unitRepository.saveOrUpdate((Object)unit);
        return unit;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MdmUnitEntity> units = this.unitRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(units) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        units.stream().forEach(unit -> unit.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.unitRepository.saveOrUpdateBatch(units);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MdmUnitEntity> units = this.unitRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        if (CollectionUtils.isEmpty(units)) {
            return;
        }
        units.stream().forEach(unit -> unit.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.unitRepository.saveOrUpdateBatch(units);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MdmUnitEntity> units = this.unitRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        if (CollectionUtils.isEmpty(units)) {
            return;
        }
        units.stream().forEach(unit -> unit.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.unitRepository.saveOrUpdateBatch(units);
    }

    @Override
    public Page<MdmUnitEntity> findByConditions(Pageable pageable, UnitPaginationQueryDto paginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return (Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.unitRepository.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)paginationDto.getTenantCode()), TenantFlagOpEntity::getTenantCode, (Object)paginationDto.getTenantCode())).eq(StringUtils.isNotBlank((CharSequence)paginationDto.getSource()), MdmUnitEntity::getSource, (Object)paginationDto.getSource())).like(StringUtils.isNotBlank((CharSequence)paginationDto.getUnitCode()), MdmUnitEntity::getUnitCode, (Object)paginationDto.getUnitCode())).like(StringUtils.isNotBlank((CharSequence)paginationDto.getUnitName()), MdmUnitEntity::getUnitName, (Object)paginationDto.getUnitName())).like(StringUtils.isNotBlank((CharSequence)paginationDto.getModifyName()), UuidOpEntity::getModifyName, (Object)paginationDto.getModifyName())).eq(StringUtils.isNotBlank((CharSequence)paginationDto.getEnableStatus()), UuidFlagOpEntity::getEnableStatus, (Object)paginationDto.getEnableStatus())).eq(StringUtils.isNotBlank((CharSequence)paginationDto.getDelFlag()), UuidFlagOpEntity::getDelFlag, (Object)paginationDto.getDelFlag())).eq(StringUtils.isBlank((CharSequence)paginationDto.getDelFlag()), UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).page((IPage)page);
    }

    @Override
    public List<MdmUnitEntity> getByCodes(List<String> codes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.unitRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(MdmUnitEntity::getUnitCode, codes)).list();
    }

    private void createValidate(MdmUnitEntity unit) {
        Validate.notNull((Object)((Object)unit), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        unit.setId(null);
        Validate.notBlank((CharSequence)unit.getUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)unit.getUnitName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MdmUnitEntity codeSameUnit = (MdmUnitEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.unitRepository.lambdaQuery().eq(MdmUnitEntity::getUnitCode, (Object)unit.getUnitCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)codeSameUnit)), (String)"\u5355\u4f4d\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        MdmUnitEntity nameSameUnit = (MdmUnitEntity)((Object)((LambdaQueryChainWrapper)this.unitRepository.lambdaQuery().eq(MdmUnitEntity::getUnitName, (Object)unit.getUnitName())).one());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)nameSameUnit)), (String)"\u5355\u4f4d\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        unit.setTenantCode(TenantUtils.getTenantCode());
        unit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isBlank((CharSequence)unit.getEnableStatus())) {
            unit.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        unit.setSource(DataSourceEnum.SELF_CREATE_SOURCE.getCode());
    }

    private void updateValidate(MdmUnitEntity unit) {
        Validate.notNull((Object)((Object)unit), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)unit.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)unit.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)unit.getUnitCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)unit.getUnitName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DataSourceEnum.SELF_CREATE_SOURCE.getCode().equals(unit.getSource()), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u975e\u81ea\u5efa\u6570\u636e\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        MdmUnitEntity codeSameUnit = (MdmUnitEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.unitRepository.lambdaQuery().ne(UuidEntity::getId, (Object)unit.getId())).eq(MdmUnitEntity::getUnitCode, (Object)unit.getUnitCode())).one());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)codeSameUnit)), (String)"\u5355\u4f4d\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        MdmUnitEntity nameSameUnit = (MdmUnitEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.unitRepository.lambdaQuery().ne(UuidEntity::getId, (Object)unit.getId())).eq(MdmUnitEntity::getUnitName, (Object)unit.getUnitName())).one());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)nameSameUnit)), (String)"\u5355\u4f4d\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        unit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isBlank((CharSequence)unit.getEnableStatus())) {
            unit.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
    }
}

