/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.unit.local.service.internal;

import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductUnitVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.unit.local.entity.MdmUnitEntity;
import com.biz.crm.mdm.business.product.unit.local.service.UnitService;
import com.biz.crm.mdm.business.product.unit.sdk.service.UnitVoService;
import com.biz.crm.mdm.business.product.unit.sdk.vo.ProductLevelUnitVo;
import com.biz.crm.mdm.business.product.unit.sdk.vo.UnitVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UnitVoServiceImpl
implements UnitVoService {
    @Autowired
    UnitService service;
    @Autowired
    NebulaToolkitService nebulaToolkitService;
    @Autowired
    ProductVoService productVoService;

    public List<UnitVo> getByCodes(List<String> codes) {
        List<MdmUnitEntity> entities = this.service.getByCodes(codes);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return entities.stream().map(s -> {
            UnitVo vo = new UnitVo();
            BeanUtils.copyProperties((Object)s, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    public List<UnitVo> getByProductLevelCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        List productVos = this.productVoService.findByProductLevelCodes(Collections.singletonList(code));
        if (CollectionUtils.isEmpty((Collection)productVos)) {
            return null;
        }
        ArrayList collect = new ArrayList();
        for (ProductVo s : productVos) {
            if (!CollectionUtils.isNotEmpty((Collection)s.getUnitList())) continue;
            collect.addAll(s.getUnitList());
        }
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return this.getByCodes(collect.stream().map(ProductUnitVo::getUnitCode).distinct().collect(Collectors.toList()));
    }

    public List<ProductLevelUnitVo> getByProductLevelCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List productVos = this.productVoService.findByProductLevelCodes(codes);
        if (CollectionUtils.isEmpty((Collection)productVos)) {
            return null;
        }
        ArrayList<ProductLevelUnitVo> vos = new ArrayList<ProductLevelUnitVo>();
        Map<String, List<ProductVo>> map = productVos.stream().collect(Collectors.groupingBy(ProductVo::getProductLevelCode));
        for (Map.Entry<String, List<ProductVo>> entry : map.entrySet()) {
            ProductLevelUnitVo vo = new ProductLevelUnitVo();
            vo.setProductLevelCode(entry.getKey());
            List<ProductVo> value = entry.getValue();
            ArrayList unitVos = new ArrayList();
            for (ProductVo s : value) {
                if (!CollectionUtils.isNotEmpty((Collection)s.getUnitList())) continue;
                unitVos.addAll(s.getUnitList());
            }
            if (CollectionUtils.isEmpty(unitVos)) {
                vo.setUnitVoList(null);
            } else {
                vo.setUnitVoList(this.getByCodes(unitVos.stream().map(ProductUnitVo::getUnitCode).distinct().collect(Collectors.toList())));
            }
            vos.add(vo);
        }
        return vos;
    }
}

