package com.biz.crm.mdm.business.qywx.synchronize.sdk.dto;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("客户事件请求数据")
public class QiYeCustomerEventDto {

  @ApiModelProperty("企业微信CorpID")
  @JSONField(name = "ToUserName")
  private String toUserName;

  @ApiModelProperty("此事件该值固定为sys，表示该消息由系统生成")
  @JSONField(name = "FromUserName")
  private String fromUserName;

  @ApiModelProperty("消息创建时间 （整型）")
  @JSONField(name = "CreateTime")
  private Integer createTime;

  @ApiModelProperty("消息的类型，此时固定为event")
  @JSONField(name = "MsgType")
  private String msgType;


  /**
   * @see com.biz.crm.mdm.business.qywx.synchronize.sdk.enums.ExternalChangeEventTypeEnum
   */
  @ApiModelProperty("事件的类型")
  @JSONField(name = "Event")
  private String event;

  /**
   * 根据event判断
   * 客户事件:
   *
   * @see com.biz.crm.mdm.business.qywx.synchronize.sdk.enums.ExternalContactChangeTypeEnum
   * <p>
   * 客户群事件:
   * @see com.biz.crm.mdm.business.qywx.synchronize.sdk.enums.ExternalChatChangeTypeEnum
   * <p>
   * 企业客户标签事件:
   * @see com.biz.crm.mdm.business.qywx.synchronize.sdk.enums.ExternalTagChangeTypeEnum
   */
  @ApiModelProperty("")
  @JSONField(name = "ChangeType")
  private String changeType;

  @ApiModelProperty("企业服务人员的UserID")
  @JSONField(name = "UserID")
  private String userID;

  @ApiModelProperty("外部联系人的userid，注意不是企业成员的帐号")
  @JSONField(name = "ExternalUserID")
  private String externalUserId;

  @ApiModelProperty("添加此用户的「联系我」方式配置的state参数，可用于识别添加此用户的渠道")
  @JSONField(name = "State")
  private String state;

  @ApiModelProperty("欢迎语code，可用于发送欢迎语")
  @JSONField(name = "WelcomeCode")
  private String welcomeCode;

  @ApiModelProperty("删除客户的操作来源，DELETE_BY_TRANSFER表示此客户是因在职继承自动被转接成员删除")
  @JSONField(name = "Source")
  private String source;

  @ApiModelProperty("群ID")
  @JSONField(name = "ChatId")
  private String chatId;

  /**
   * 当even是change_external_chat 且changeType为update时
   *
   * @see com.biz.crm.mdm.business.qywx.synchronize.sdk.enums.ExternalChatUpdateChangeTypeEnum
   */
  @ApiModelProperty("变更详情")
  @JSONField(name = "UpdateDetail")
  private String updateDetail;

  /**
   * 当 updateDetail 为 add_member时有值
   * 0 - 由成员邀请入群（包括直接邀请入群和通过邀请链接入群）
   * 3 - 通过扫描群二维码入群
   */
  @ApiModelProperty("当是成员入群时有值。表示成员的入群方式")
  @JSONField(name = "JoinScene")
  private String joinScene;
  /**
   * 当 updateDetail 为 del_member时
   * 0 - 自己退群
   * 1 - 群主/群管理员移出
   */
  @ApiModelProperty("当是成员退群时有值。表示成员的退群方式")
  @JSONField(name = "QuitScene")
  private String quitScene;

  /**
   * 当是成员入群或退群时有值。表示成员变更数量
   */
  @ApiModelProperty("当是成员入群或退群时有值。表示成员变更数量")
  @JSONField(name = "MemChangeCnt")
  private String memChangeCnt;

  @ApiModelProperty("标签或标签组的ID")
  @JSONField(name = "Id")
  private String id;

  @ApiModelProperty("创建标签时，此项为tag，创建标签组时，此项为tag_group")
  @JSONField(name = "TagType")
  private String tagType;

  @ApiModelProperty("标签或标签组所属的规则组id，只回调给“客户联系”应用")
  @JSONField(name = "StrategyId")
  private String strategyId;


}
