package com.biz.crm.mdm.business.qywx.synchronize.sdk.enums;

/**
 * 客户群变更事件明细类型
 */
public enum ExternalChatUpdateChangeTypeEnum {

  ADD_MEMBER("add_member ", "成员入群"),
  DEL_MEMBER("del_member", "成员退群"),
  CHANGE_OWNER("change_owner", "群主变更"),
  CHANGE_NAME("change_name ", "群名变更"),
  CHANGE_NOTICE("change_name ", "群公告变更");


  /**
   * 编码
   */
  private String code;

  /**
   * 说明
   */
  private String value;

  ExternalChatUpdateChangeTypeEnum(String code, String value) {
    this.code = code;
    this.value = value;
  }

  /**
   * 根据code转枚举
   *
   * @param code
   * @return
   */
  public static ExternalChatUpdateChangeTypeEnum codeToEnum(String code) {
    ExternalChatUpdateChangeTypeEnum result = null;
    for (ExternalChatUpdateChangeTypeEnum productLevelEnum : ExternalChatUpdateChangeTypeEnum.values()) {
      if (productLevelEnum.code.equals(code)) {
        result = productLevelEnum;
      }
    }
    return result;
  }

  public String getCode() {
    return code;
  }

  public String getValue() {
    return value;
  }
}
