package com.biz.crm.mdm.business.qywx.synchronize.sdk.enums;

/**
 * 企业客户标签变更事件类型
 */
public enum ExternalTagChangeTypeEnum {

  CREATE("create", "企业客户标签创建"),
  UPDATE("update", "企业客户标签变更"),
  DELETE("del_external_contact", "企业客户标签删除"),
  SHUFFLE("shuffle","企业客户标签重排");


  /**
   * 编码
   */
  private String code;

  /**
   * 说明
   */
  private String value;

  ExternalTagChangeTypeEnum(String code, String value) {
    this.code = code;
    this.value = value;
  }

  /**
   * 根据code转枚举
   *
   * @param code
   * @return
   */
  public static ExternalTagChangeTypeEnum codeToEnum(String code) {
    ExternalTagChangeTypeEnum result = null;
    for (ExternalTagChangeTypeEnum productLevelEnum : ExternalTagChangeTypeEnum.values()) {
      if (productLevelEnum.code.equals(code)) {
        result = productLevelEnum;
      }
    }
    return result;
  }

  public String getCode() {
    return code;
  }

  public String getValue() {
    return value;
  }
}
