package com.biz.crm.mdm.business.businessunit.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.businessunit.feign.feign.internal.BusinessUnitVoFeignImpl;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 业务单元feign接口类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 13:59
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = BusinessUnitVoFeignImpl.class)
public interface BusinessUnitVoFeign {
    /**
     * 多条件分页查询
     *
     * @param page 分页参数
     * @param size 分页参数
     * @param dto      查询参数
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 14:15
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping("/v1/mdmBusinessUnit/mdmBusinessUnitVo/findByConditions")
    Result<Page<MdmBusinessUnitVo>> findByConditions(
            @RequestParam("page") Integer page,
            @RequestParam("size") Integer size,
            @SpringQueryMap MdmBusinessUnitDto dto);

    /**
     * 根据ID查询详情
     *
     * @param id ID
     * @return com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:25
     */
    @ApiOperation(value = "根据id详情")
    @GetMapping("/v1/mdmBusinessUnit/mdmBusinessUnitVo/findById")
    Result<MdmBusinessUnitVo> findById(@RequestParam("id") String id);

    /**
     * 根据ID集合查询详情
     *
     * @param idList ID集合
     * @return java.util.List<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:26
     */
    @ApiOperation(value = "根据id集合详情")
    @GetMapping("/v1/mdmBusinessUnit/mdmBusinessUnitVo/findByIds")
    Result<List<MdmBusinessUnitVo>> findByIds(@RequestParam("idList") List<String> idList);

    /**
     * 根据编码查询详情
     *
     * @param code 编码
     * @return com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:27
     */
    @ApiOperation(value = "根据编码查询详情")
    @GetMapping("/v1/mdmBusinessUnit/mdmBusinessUnitVo/findByCode")
    Result<MdmBusinessUnitVo> findByCode(@RequestParam("code") String code);

    /**
     * 根据编码集合查询详情
     *
     * @param codeList 编码集合
     * @return java.util.List<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:27
     */
    @ApiOperation(value = "根据编码集合查询详情")
    @GetMapping("/v1/mdmBusinessUnit/mdmBusinessUnitVo/findByCodes")
    Result<List<MdmBusinessUnitVo>> findByCodes(@RequestParam("codeList") List<String> codeList);


}
