package com.biz.crm.mdm.business.businessunit.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.businessunit.feign.feign.BusinessUnitVoFeign;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 业务单元feign接口熔断类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 13:59
 */
@Component
public class BusinessUnitVoFeignImpl implements FallbackFactory<BusinessUnitVoFeign> {
    @Override
    public BusinessUnitVoFeign create(Throwable throwable) {
        return new BusinessUnitVoFeign() {
            @Override
            public Result<Page<MdmBusinessUnitVo>> findByConditions(Integer page, Integer size, MdmBusinessUnitDto dto) {
                throw new UnsupportedOperationException("根据条件查询业务单元列表熔断");
            }

            @Override
            public Result<MdmBusinessUnitVo> findById(String id) {
                throw new UnsupportedOperationException("根据ID查询业务单元熔断");
            }

            @Override
            public Result<List<MdmBusinessUnitVo>> findByIds(List<String> idList) {
                throw new UnsupportedOperationException("根据ID集合查询业务单元熔断");
            }

            @Override
            public Result<MdmBusinessUnitVo> findByCode(String code) {
                throw new UnsupportedOperationException("根据编码查询业务单元熔断");
            }

            @Override
            public Result<List<MdmBusinessUnitVo>> findByCodes(List<String> codeList) {
                throw new UnsupportedOperationException("根据编码集合查询业务单元熔断");
            }
        };
    }
}
