package com.biz.crm.mdm.business.businessunit.feign.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.businessunit.feign.feign.BusinessUnitVoFeign;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmFormatCodeDto;
import com.biz.crm.mdm.business.businessunit.sdk.service.MdmBusinessUnitVoService;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;

/**
 * 业务单元(MdmBusinessUnit)
 *
 * @author yaoyongming
 * @since 2022-10-18 17:28:36
 */
@Service
public class MdmBusinessUnitServiceImpl implements MdmBusinessUnitVoService {

    @Autowired(required = false)
    private BusinessUnitVoFeign businessUnitVoFeign;

    /**
     * 多条件分页查询
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 14:15
     */
    @Override
    public Page<MdmBusinessUnitVo> findByConditions(Pageable pageable, MdmBusinessUnitDto dto) {
        Result<Page<MdmBusinessUnitVo>> result = businessUnitVoFeign.findByConditions(pageable.getPageNumber(),pageable.getPageSize(), dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }


    /**
     * 根据ID查询详情
     *
     * @param id ID
     * @return com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:25
     */
    @Override
    public MdmBusinessUnitVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        Result<MdmBusinessUnitVo> result = businessUnitVoFeign.findById(id);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据ID集合查询详情
     *
     * @param idList ID集合
     * @return java.util.List<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:26
     */
    @Override
    public List<MdmBusinessUnitVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Result<List<MdmBusinessUnitVo>> result = businessUnitVoFeign.findByIds(idList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据编码查询详情
     *
     * @param code 编码
     * @return com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:27
     */
    @Override
    public MdmBusinessUnitVo findByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        Result<MdmBusinessUnitVo> result = businessUnitVoFeign.findByCode(code);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据编码集合查询详情
     *
     * @param codeList 编码集合
     * @return java.util.List<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:27
     */
    @Override
    public List<MdmBusinessUnitVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<MdmBusinessUnitVo>> result = businessUnitVoFeign.findByCodes(codeList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 新增
     *
     * @param mdmUnit
     * @return
     */
    @Override
    public MdmBusinessUnitVo create(MdmBusinessUnitDto mdmUnit) {
        throw new UnsupportedOperationException();
    }

    /**
     * 修改
     *
     * @param mdmUnit
     * @return
     */
    @Override
    public MdmBusinessUnitVo update(MdmBusinessUnitDto mdmUnit) {
        throw new UnsupportedOperationException();
    }

    /**
     * 删除
     *
     * @param idList
     */
    @Override
    public void delete(List<String> idList) {
        throw new UnsupportedOperationException();
    }


    /**
     * 批量启用
     *
     * @param ids
     */
    @Override
    public void enableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    /**
     * 批量禁用
     *
     * @param ids
     */
    @Override
    public void disableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<DictDataVo> findFormatByConditions(Pageable pageable, MdmFormatCodeDto codeDto) {
        throw new UnsupportedOperationException();
    }


}

