package com.biz.crm.mdm.business.businessunit.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 业态进行授权的选项分组数据权限 业态分组注册器
 */
@Component("BusinessFormatAuthorityModeGroupRegister")
public class BusinessFormatAuthorityModeGroupRegister implements SelectAuthorityModeGroupRegister {
    @Override
    public String groupCode() {
        return "business_format_group";
    }

    @Override
    public String groupName() {
        return "按照业态维度授权";
    }

    @Override
    public Set<String> viewFieldNames() {
        return Sets.newHashSet("businessFormatCode", "business_format_code");
    }

    @Override
    public Set<String> repositoryFieldNames() {
        return Sets.newHashSet("businessFormatCode", "business_format_code");
    }
}
