package com.biz.crm.mdm.business.businessunit.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 业务单元进行授权的选项分组数据权限 业务分组注册器
 */
@Component("BusinessUnitAuthorityModeGroupRegister")
public class BusinessUnitAuthorityModeGroupRegister implements SelectAuthorityModeGroupRegister {
    @Override
    public String groupCode() {
        return "business_unit_group";
    }

    @Override
    public String groupName() {
        return "按照业务单元维度授权";
    }

    @Override
    public Set<String> viewFieldNames() {
        return Sets.newHashSet("business_unit_code", "businessUnitCode");
    }

    @Override
    public Set<String> repositoryFieldNames() {
        return Sets.newHashSet("business_unit_code", "businessUnitCode");
    }
}
