package com.biz.crm.mdm.business.businessunit.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/28 10:32
 * @description: 业务单元数据行权限 按照固定的业务单元值进行业务单元维度的值确认
 */
@Component("businessUnitAuthorityRegisterForSelectValues")
public class BusinessUnitAuthorityRegisterForSelectValues implements SelectAuthorityModeRegister {
    @Override
    public String modeKey() {
        return "businessUnitAuthorityRegisterForSelectValues";
    }

    @Override
    public String modeName() {
        return "按照固定的业务单元值进行业务单元维度的值确认";
    }

    @Override
    public String controlKey() {
        return "businessUnitAuthorityRegisterForSelectValues_select";
    }

    @Override
    public int sort() {
        return 15;
    }

    @Override
    public String groupCode() {
        return "business_unit_group";
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return true;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return staticValues;
    }

    @Override
    public Object dynamicValue(UserIdentity userIdentity, String modeGroupCode) {
        return null;
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }
}
