package com.biz.crm.mdm.business.businessunit.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/28 10:46
 * @description: 创建人数据行权限 按照当前登录者/操作者的账号进行创建人维度的值确认
 */
@Component("CreateUserAuthorityRegisterForCurrentUsers")
public class CreateUserAuthorityRegisterForCurrentUsers implements SelectAuthorityModeRegister {
    @Override
    public String modeKey() {
        return "createUserAuthorityRegisterForCurrentUsers";
    }

    @Override
    public String modeName() {
        return "按照当前登录者/操作者的账号进行创建人维度的值确认";
    }

    @Override
    public String controlKey() {
        return "createUserAuthorityRegisterForCurrentUsers";
    }

    @Override
    public int sort() {
        return 12;
    }

    @Override
    public String groupCode() {
        return "create_account_group";
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] strings) {
        return null;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        String identityType = loginDetails.getIdentityType();
        //如果不是后台管理用户，就不组织位字段进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return null;
        }
        AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
        List<String> accounts = new ArrayList<>();
        accounts.add(loginUserDetails.getAccount());
        return accounts.toArray(new String[0]);
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }
}
