package com.biz.crm.mdm.business.businessunit.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @Author: chenlong
 * @Date: 2022/12/29 16:50
 * description: 按照售达方维度授权
 */
@Component("soldToPartyAuthorityModeGroupRegister")
public class SoldToPartyAuthorityModeGroupRegister implements SelectAuthorityModeGroupRegister {
    @Override
    public String groupCode() {
        return "sold_to_party_group";
    }

    @Override
    public String groupName() {
        return "按照售达方维度授权";
    }

    @Override
    public Set<String> viewFieldNames() {
        return Sets.newHashSet("soldToPartyCodes", "soldToPartyCode", "sold_to_party_codes", "sold_to_party_code");
    }

    @Override
    public Set<String> repositoryFieldNames() {
        return Sets.newHashSet("sold_to_party_codes", "sold_to_party_code");
    }
}
