package com.biz.crm.mdm.business.businessunit.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 按照固定售达方
 */
@Component("soldToPartyAuthorityModeRegisterForSelect")
public class SoldToPartyAuthorityModeRegisterForSelect implements SelectAuthorityModeRegister {

    @Override
    public String modeKey() {
        return "soldToPartyAuthorityModeRegisterForSelect";
    }

    @Override
    public String modeName() {
        return "按照固定售达方进行售达方维度的值确认";
    }

    @Override
    public String controlKey() {
        return "soldToPartyAuthorityModeRegisterForSelect_select";
    }

    @Override
    public int sort() {
        return 22;
    }

    @Override
    public String groupCode() {
        return "sold_to_party_group";
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return true;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return staticValues;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        return null;
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }
}
