package com.biz.crm.mdm.business.businessunit.local.controller;


import com.biz.crm.mdm.business.businessunit.local.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.local.entity.MdmBusinessUnit;
import com.biz.crm.mdm.business.businessunit.local.service.MdmBusinessUnitService;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 业务单元(MdmBusinessUnit)
 *
 * @author yaoyongming
 * @since 2022-10-18 17:28:31
 */
@RestController
@RequestMapping("/v1/mdmBusinessUnit")
@Slf4j
@Api(tags = "MDM-业务单元")
public class MdmBusinessUnitController {

    @Autowired(required = false)
    private MdmBusinessUnitService mdmBusinessUnitService;

    @ApiOperation(value = "查询分页列表")
    @GetMapping("findByConditions")
    public Result<Page<MdmBusinessUnit>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                  @ApiParam(name = "mdmUnitDto", value = "业务单元") MdmBusinessUnitDto mdmUnit) {
        try {
            Page<MdmBusinessUnit> page = this.mdmBusinessUnitService.findByConditions(pageable, mdmUnit);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "详情")
    @GetMapping("findById")
    public Result<MdmBusinessUnit> findById(@RequestParam("id") String id) {
        try {
            MdmBusinessUnit mdmUnit = this.mdmBusinessUnitService.findById(id);
            return Result.ok(mdmUnit);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "新增")
    @PostMapping("create")
    public Result<MdmBusinessUnit> create(@ApiParam(name = "mdmBusinessUnit", value = "业务单元") @RequestBody MdmBusinessUnit mdmUnit) {
        try {
            MdmBusinessUnit result = this.mdmBusinessUnitService.create(mdmUnit);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "修改")
    @PatchMapping("update")
    public Result<MdmBusinessUnit> update(@ApiParam(name = "mdmBusinessUnit", value = "业务单元") @RequestBody MdmBusinessUnit mdmUnit) {
        try {
            MdmBusinessUnit result = this.mdmBusinessUnitService.update(mdmUnit);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "删除")
    @DeleteMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "idList") @RequestParam("idList") List<String> idList) {
        try {
            this.mdmBusinessUnitService.delete(idList);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PatchMapping("enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.mdmBusinessUnitService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.mdmBusinessUnitService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
