package com.biz.crm.mdm.business.businessunit.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmFormatCodeDto;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.sdk.service.MdmBusinessUnitVoService;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 业务单元(MdmBusinessUnit)
 *
 * @author yaoyongming
 * @since 2022-10-18 17:28:31
 */
@Api(value = "业务单元", tags = "MDM-业务单元VO")
@RestController
@RequestMapping("/v1/mdmBusinessUnit/mdmBusinessUnitVo")
@Slf4j
public class MdmBusinessUnitVoController {

    @Autowired(required = false)
    private MdmBusinessUnitVoService mdmBusinessUnitVoService;

    @ApiOperation(value = "查询分页列表")
    @GetMapping("findByConditions")
    public Result<Page<MdmBusinessUnitVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "dto", value = "业务单元") MdmBusinessUnitDto dto) {
        try {
            Page<MdmBusinessUnitVo> page = this.mdmBusinessUnitVoService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据id详情")
    @GetMapping("findById")
    public Result<MdmBusinessUnitVo> findById(@RequestParam("id") String id) {
        try {
            MdmBusinessUnitVo mdmUnit = this.mdmBusinessUnitVoService.findById(id);
            return Result.ok(mdmUnit);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据id集合详情")
    @GetMapping(value = {"/findByIds"})
    public Result<List<MdmBusinessUnitVo>> findByIds(@RequestParam("idList") List<String> idList) {
        try {
            List<MdmBusinessUnitVo> list = this.mdmBusinessUnitVoService.findByIds(idList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据编码查询详情")
    @GetMapping("findByCode")
    public Result<MdmBusinessUnitVo> findByCode(@RequestParam("code") String code) {
        try {
            MdmBusinessUnitVo mdmUnit = this.mdmBusinessUnitVoService.findByCode(code);
            return Result.ok(mdmUnit);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据编码集合查询详情")
    @GetMapping(value = {"/findByCodes"})
    public Result<List<MdmBusinessUnitVo>> findByCodes(@RequestParam("codeList") List<String> codeList) {
        try {
            List<MdmBusinessUnitVo> list = this.mdmBusinessUnitVoService.findByCodes(codeList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "新增")
    @PostMapping("create")
    public Result<MdmBusinessUnitVo> create(@ApiParam(name = "dto", value = "业务单元") @RequestBody MdmBusinessUnitDto dto) {
        try {
            MdmBusinessUnitVo result = this.mdmBusinessUnitVoService.create(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "修改")
    @PatchMapping("update")
    public Result<MdmBusinessUnitVo> update(@ApiParam(name = "dto", value = "业务单元") @RequestBody MdmBusinessUnitDto dto) {
        try {
            MdmBusinessUnitVo result = this.mdmBusinessUnitVoService.update(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "删除")
    @DeleteMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "idList") @RequestParam("idList") List<String> idList) {
        try {
            this.mdmBusinessUnitVoService.delete(idList);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PatchMapping("enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.mdmBusinessUnitVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.mdmBusinessUnitVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询业态分页列表（通过数据字典转换，数据权限使用请勿修改）")
    @GetMapping("findFormatByConditions")
    public Result<Page<DictDataVo>> findFormatByConditions(@PageableDefault(value = 50,page = 1) Pageable pageable,
                                                           @ApiParam(name = "codeDto", value = "业态") MdmFormatCodeDto codeDto) {
        try {
            Page<DictDataVo> page = this.mdmBusinessUnitVoService.findFormatByConditions(pageable, codeDto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
