package com.biz.crm.mdm.business.businessunit.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * @describe: 业务单元实体
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.25 11:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_business_unit")
@ApiModel(value = "BusinessUnitEntity", description = "业务单元")
@Table(
        name = "mdm_business_unit",
        indexes = {
                @Index(name = "mdm_unit_index1", unique = true, columnList = "business_unit_code"),
        })
@org.hibernate.annotations.Table(appliesTo = "mdm_business_unit", comment = "业务单元")
public class MdmBusinessUnit extends TenantFlagOpEntity {

    /**
     * 业务单元编码
     */
    @TableField(value = "business_unit_code")
    @Column(name = "business_unit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元编码'")
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 业务单元名称
     */
    @TableField(value = "business_unit_name")
    @Column(name = "business_unit_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元名称'")
    @ApiModelProperty(name = "businessUnitName", notes = "业务单元名称")
    private String businessUnitName;

    /**
     * 税率
     */
    @TableField(value = "tax_ratio")
    @Column(name = "tax_ratio", columnDefinition = "decimal(10,2) COMMENT '税率'")
    @ApiModelProperty(name = "taxRatio", notes = "税率")
    private BigDecimal taxRatio;

}
