package com.biz.crm.mdm.business.businessunit.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * @describe: 业务单元实体
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.25 11:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_business_unit_detail")
@ApiModel(value = "BusinessUnitEntity", description = "业务单元")
@Table(
        name = "mdm_business_unit_detail",
        indexes = {
                @Index(name = "mdm_business_unit_detail_index1", unique = false, columnList = "business_unit_code"),
        })
@org.hibernate.annotations.Table(appliesTo = "mdm_business_unit_detail", comment = "业务单元")
public class MdmBusinessUnitDetail extends TenantFlagOpEntity {

    private static final long serialVersionUID = -8707434660634317356L;
    /**
     * 业务单元编码
     */
    @TableField(value = "business_unit_code")
    @Column(name = "business_unit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元编码'")
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String salesOrgName;

    /**
     * 渠道编码
     */
    @ApiModelProperty(name = "渠道编码", notes = "渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(name = "渠道名称", notes = "渠道名称")
    @Column(name = "channel_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '渠道名称'")
    private String channelName;

}
