package com.biz.crm.mdm.business.businessunit.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.businessunit.local.entity.MdmBusinessUnitDetail;
import com.biz.crm.mdm.business.businessunit.local.mapper.MdmBusinessUnitDetailMapper;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDetailDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;


/**
 * 业务单元(MdmBusinessUnit)
 *
 * @author yaoyongming
 * @since 2022-10-18 17:28:37
 */
@Component
public class MdmBusinessUnitDetailRepository extends ServiceImpl<MdmBusinessUnitDetailMapper, MdmBusinessUnitDetail> {

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 批量新增、更新
     *
     * @param unitDetailList
     * @author huojia
     * @date 2022/11/24 14:47
     **/
    public void saveOrUpdateBatch(List<MdmBusinessUnitDetailDto> unitDetailList) {
        if (CollectionUtils.isEmpty(unitDetailList)) {
            return;
        }
        String businessUnitCode = unitDetailList.get(0).getBusinessUnitCode();
        List<MdmBusinessUnitDetail> mdmBusinessUnitDetailList = this.lambdaQuery()
                .eq(MdmBusinessUnitDetail::getBusinessUnitCode, businessUnitCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if (!CollectionUtils.isEmpty(mdmBusinessUnitDetailList)) {
            mdmBusinessUnitDetailList.forEach(unitDetail -> {
                unitDetail.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(mdmBusinessUnitDetailList);
        }
        List<MdmBusinessUnitDetail> mdmBusinessUnitDetails = (List<MdmBusinessUnitDetail>) this.nebulaToolkitService.copyCollectionByWhiteList(
                unitDetailList, MdmBusinessUnitDetailDto.class, MdmBusinessUnitDetail.class, LinkedHashSet.class, ArrayList.class
        );
        this.saveOrUpdateBatch(mdmBusinessUnitDetails);
    }

    /**
     * 根据业务单元编码批量删除
     *
     * @param unitCodeList
     * @author huojia
     * @date 2022/11/24 15:31
     **/
    public void delByUnitCode(List<String> unitCodeList) {
        if (CollectionUtils.isEmpty(unitCodeList)) {
            return;
        }
        List<MdmBusinessUnitDetail> mdmBusinessUnitDetailList = this.lambdaQuery()
                .in(MdmBusinessUnitDetail::getBusinessUnitCode, unitCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        mdmBusinessUnitDetailList.forEach(mdmBusinessUnitDetail -> {
            mdmBusinessUnitDetail.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.updateBatchById(mdmBusinessUnitDetailList);
    }

    /**
     * 批量查询
     *
     * @param codeList
     * @return java.util.List<com.biz.crm.mdm.business.businessunit.local.entity.MdmBusinessUnitDetail>
     * @author huojia
     * @date 2022/11/24 15:38
     **/
    public List<MdmBusinessUnitDetail> listByUnitCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(MdmBusinessUnitDetail::getBusinessUnitCode, codeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}

