package com.biz.crm.mdm.business.businessunit.local.repository;


import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.businessunit.local.entity.MdmBusinessUnit;
import com.biz.crm.mdm.business.businessunit.local.mapper.MdmBusinessUnitMapper;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;


/**
 * 业务单元(MdmBusinessUnit)
 *
 * @author yaoyongming
 * @since 2022-10-18 17:28:37
 */
@Component
public class MdmBusinessUnitRepository extends ServiceImpl<MdmBusinessUnitMapper, MdmBusinessUnit> {

    @Autowired(required = false)
    private MdmBusinessUnitMapper mdmBusinessUnitMapper;

    /**
     * 分页查询
     *
     * @param page    分页参数
     * @param mdmUnit 查询参数
     * @return
     */
    public Page<MdmBusinessUnitVo> findByConditions(Page<MdmBusinessUnitVo> page, MdmBusinessUnitDto mdmUnit) {
        return this.mdmBusinessUnitMapper.findByConditions(page, mdmUnit);
    }

    /**
     * 根据主键集合，修改 enable_status
     *
     * @param enable
     * @param ids
     */
    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper<MdmBusinessUnit> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("enable_status", enable.getCode());
        updateWrapper.in("id", ids);
        this.update(updateWrapper);
    }

    /**
     * 根据id获取详情
     *
     * @param id ID
     * @return
     */
    public MdmBusinessUnit findById(String id) {
        if (!StringUtils.hasText(id)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(MdmBusinessUnit::getId, id)
                .eq(MdmBusinessUnit::getTenantCode, TenantUtils.getTenantCode())
                .eq(MdmBusinessUnit::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param idList ID集合
     * @return
     */
    public List<MdmBusinessUnit> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(MdmBusinessUnit::getId, idList)
                .eq(MdmBusinessUnit::getTenantCode, TenantUtils.getTenantCode())
                .eq(MdmBusinessUnit::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据编码获取详情
     *
     * @param code 编码
     * @return
     */
    public MdmBusinessUnit findByCode(String code) {
        if (!StringUtils.hasText(code)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(MdmBusinessUnit::getBusinessUnitCode, code)
                .eq(MdmBusinessUnit::getTenantCode, TenantUtils.getTenantCode())
                .eq(MdmBusinessUnit::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    /**
     * 根据编码集合获取详情集合
     *
     * @param codeList 编码集合
     * @return
     */
    public List<MdmBusinessUnit> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(MdmBusinessUnit::getBusinessUnitCode, codeList)
                .eq(MdmBusinessUnit::getTenantCode, TenantUtils.getTenantCode())
                .eq(MdmBusinessUnit::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}

