package com.biz.crm.mdm.business.businessunit.local.service;


import com.biz.crm.mdm.business.businessunit.local.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.local.entity.MdmBusinessUnit;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 业务单元(MdmBusinessUnit)
 *
 * @author yaoyongming
 * @since 2022-10-18 17:28:32
 */
public interface MdmBusinessUnitService {

    /**
     * 多条件分页查询
     *
     * @param pageable
     * @param mdmUnit
     * @return
     */
    Page<MdmBusinessUnit> findByConditions(Pageable pageable, MdmBusinessUnitDto mdmUnit);

    /**
     * 按照实体中的（id）主键进行查询明细查询
     *
     * @param id
     * @return
     */
    MdmBusinessUnit findById(String id);

    /**
     * 新增
     *
     * @param mdmUnit
     * @return
     */
    MdmBusinessUnit create(MdmBusinessUnit mdmUnit);

    /**
     * 修改
     *
     * @param mdmUnit
     * @return
     */
    MdmBusinessUnit update(MdmBusinessUnit mdmUnit);

    /**
     * 删除
     *
     * @param idList
     * @return
     */
    void delete(List<String> idList);

    /**
     * 批量启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);
}

