package com.biz.crm.mdm.business.businessunit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author HuoJia
 */
@ApiModel(value = "MdmBusinessUnitDto", description = "MDM-业务单元")
@Getter
@Setter
public class MdmBusinessUnitDto extends TenantFlagOpDto {

    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "业务单元编码", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 业务单元名称
     */
    @ApiModelProperty(value = "业务单元名称", notes = "业务单元名称")
    private String businessUnitName;

    /**
     * 查询
     */
    @ApiModelProperty(value = "查询", notes = "业务单元编码/名称")
    private String unionCodeName;

    /**
     * 税率
     */
    @ApiModelProperty(name = "taxRatio", notes = "税率")
    private BigDecimal taxRatio;

    /**
     * 业务单元明细
     */
    @ApiModelProperty(value = "业务单元明细", notes = "业务单元明细")
    private List<MdmBusinessUnitDetailDto> unitDetailList;

}
