package com.biz.crm.mdm.business.businessunit.sdk.event;

import com.biz.crm.mdm.business.businessunit.sdk.dto.BusinessUnitEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 业务单元变更事件通知接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.9 18:23
 */
public interface BusinessUnitEventListener extends NebulaEvent {

    /**
     * 当业务单元创建时触发
     *
     * @param dto
     */
    default void onCreate(BusinessUnitEventDto dto) {
    }

    /**
     * 当业务单元修改时触发
     *
     * @param dto
     */
    default void onUpdate(BusinessUnitEventDto dto) {
    }

    /**
     * 当业务单元禁用时触发
     *
     * @param dto
     */
    default void onDisable(BusinessUnitEventDto dto) {
    }

    /**
     * 当业务单元启用时触发
     *
     * @param dto
     */
    default void onEnable(BusinessUnitEventDto dto) {
    }

    /**
     * 当业务单元删除时触发
     *
     * @param dto
     */
    default void onDelete(BusinessUnitEventDto dto) {
    }

}
