package com.biz.crm.mdm.business.businessunit.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmFormatCodeDto;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 业务单元(MdmBusinessUnit)
 *
 * @author yaoyongming
 * @since 2022-10-18 17:28:32
 */
public interface MdmBusinessUnitVoService {

    /**
     * 多条件分页查询
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 14:15
     */
    Page<MdmBusinessUnitVo> findByConditions(Pageable pageable, MdmBusinessUnitDto dto);

    /**
     * 根据ID查询详情
     *
     * @param id ID
     * @return com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:25
     */
    MdmBusinessUnitVo findById(String id);

    /**
     * 根据ID集合查询详情
     *
     * @param idList ID集合
     * @return java.util.List<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:26
     */
    List<MdmBusinessUnitVo> findByIds(List<String> idList);

    /**
     * 根据编码查询详情
     *
     * @param code 编码
     * @return com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:27
     */
    MdmBusinessUnitVo findByCode(String code);

    /**
     * 根据编码集合查询详情
     *
     * @param codeList 编码集合
     * @return java.util.List<com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.5 0:27
     */
    List<MdmBusinessUnitVo> findByCodes(List<String> codeList);

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    MdmBusinessUnitVo create(MdmBusinessUnitDto dto);

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    MdmBusinessUnitVo update(MdmBusinessUnitDto dto);

    /**
     * 删除
     *
     * @param idList
     * @return
     */
    void delete(List<String> idList);

    /**
     * 批量启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);


    /**
     * 查询业态分页列表（通过数据字典转换，数据权限使用请勿修改）
     *
     * @param pageable 分页参数
     * @param codeDto 筛选参数
     * @return  Page<DictDataVo>
     */
    Page<DictDataVo> findFormatByConditions(Pageable pageable, MdmFormatCodeDto codeDto);
}

