package com.biz.crm.mdm.business.businessunit.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;


/**
 * @describe: 业务单元实体
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.25 11:42
 */
@ApiModel(value = "MdmBusinessUnitDetailDto", description = "MDM-业务单元明细")
@Getter
@Setter
public class MdmBusinessUnitDetailVo extends TenantFlagOpVo {

    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码", notes = "渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称", notes = "渠道名称")
    private String channelName;

}
