package com.biz.crm.mdm.business.businessunit.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;


/**
 * @describe: 业务单元实体
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.25 11:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MdmBusinessUnitVo extends TenantFlagOpVo {

    private static final long serialVersionUID = -1459535823885585725L;
    /**
     * 业务单元编码
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 业务单元名称
     */
    @ApiModelProperty(name = "businessUnitName", notes = "业务单元名称")
    private String businessUnitName;

    /**
     * 税率
     */
    @ApiModelProperty(name = "taxRatio", notes = "税率")
    private BigDecimal taxRatio;

    /**
     * 业务单元明细
     */
    @ApiModelProperty(value = "业务单元明细", notes = "业务单元明细")
    private List<MdmBusinessUnitDetailVo> unitDetailList;
}
