package com.biz.crm.mdm.business.channel.org.employee.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.channel.org.employee.local.entity.ChannelOrgEmployee;
import com.biz.crm.mdm.business.channel.org.employee.local.service.ChannelOrgEmployeeService;
import com.biz.crm.mdm.business.channel.org.employee.sdk.service.ChannelOrgEmployeeVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 渠道组织员工表(ChannelOrgEmployee)表相关的http接口
 *
 * @author songjingen
 * @since 2022-11-23 10:32:48
 */
@RestController
@RequestMapping("/v1/channelOrgEmployee/channelOrgEmployee")
@Slf4j
@Api(tags = "渠道组织员工表：ChannelOrgEmployee：渠道组织员工表")
public class ChannelOrgEmployeeController {

  /**
   * 服务对象
   */
  @Autowired
  private ChannelOrgEmployeeService channelOrgEmployeeService;
  @Autowired(required = false)
  private ChannelOrgEmployeeVoService channelOrgEmployeeVoService;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<ChannelOrgEmployee> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      ChannelOrgEmployee channelOrgEmployee = this.channelOrgEmployeeService.findById(id);
      return Result.ok(channelOrgEmployee);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param channelOrgEmployees 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<List<ChannelOrgEmployee>> create(@ApiParam(name = "channelOrgEmployee", value = "渠道组织员工表") @RequestBody List<ChannelOrgEmployee> channelOrgEmployees) {
    try {
      List<ChannelOrgEmployee> result = this.channelOrgEmployeeService.create(channelOrgEmployees);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.channelOrgEmployeeService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.channelOrgEmployeeService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.channelOrgEmployeeService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过渠道组织编码查询用户编码
   *
   * @param channelOrgCode 渠道组织编码
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("findUserCodesByChannelOrgCode")
  public Result<List<String>> findUserCodesByChannelOrgCode(@RequestParam @ApiParam(name = "channelOrgCode", value = "渠道组织编码") String channelOrgCode) {
    try {
      List<String> userCodes = this.channelOrgEmployeeVoService.findUserCodesByChannelOrgCode(channelOrgCode);
      return Result.ok(userCodes);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
