package com.biz.crm.mdm.business.channel.org.employee.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 渠道组织员工实体表
 *
 * @author songjingen
 * @date 2022/11/21 20:30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ChannelOrgEmployee", description = "渠道组织员工实体表")
@Entity
@TableName("mdm_channel_org_employee")
@Table(name = "mdm_channel_org_employee", indexes = {
    @Index(name = "mdm_channel_org_employee_index1", columnList = "user_code,tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_channel_org_employee", comment = "渠道组织员工表")
public class ChannelOrgEmployee extends TenantFlagOpEntity {

  /**
   * 企业用户账号
   */
  @ApiModelProperty("企业用户编码")
  @Column(name = "user_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '企业用户编码'")
  private String userCode;

  /**
   * 渠道组织编码
   */
  @ApiModelProperty("渠道组织编码")
  @Column(name = "channel_org_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '渠道组织编码'")
  private String channelOrgCode;

  /**
   * 渠道组织名称
   */
  @ApiModelProperty("渠道组织名称")
  @Column(name = "channel_org_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '渠道组织名称'")
  private String channelOrgName;

}
