package com.biz.crm.mdm.business.channel.org.employee.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.channel.org.employee.local.entity.ChannelOrgEmployee;
import com.biz.crm.mdm.business.channel.org.employee.local.mapper.ChannelOrgEmployeeMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 渠道组织员工表(ChannelOrgEmployee)表数据库访问层
 *
 * @author songjingen
 * @since 2022-11-23 10:32:48
 */
@Component
public class ChannelOrgEmployeeRepository extends ServiceImpl<ChannelOrgEmployeeMapper, ChannelOrgEmployee> {

  /**
   * 根据id集合查询数据
   *
   * @param idList id集合
   * @return
   */
  public List<ChannelOrgEmployee> findByIds(List<String> idList) {
    return this.lambdaQuery().eq(ChannelOrgEmployee::getTenantCode, TenantUtils.getTenantCode())
        .eq(ChannelOrgEmployee::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(ChannelOrgEmployee::getId, idList)
        .list();
  }

  /**
   * 根据id集合和启禁用状态查询数据
   *
   * @param statusEnum 启禁用状态
   * @param idList     id集合
   * @return
   */
  public List<ChannelOrgEmployee> findEnableStatusByIds(EnableStatusEnum statusEnum, List<String> idList) {
    return this.lambdaQuery().eq(ChannelOrgEmployee::getTenantCode, TenantUtils.getTenantCode())
        .eq(ChannelOrgEmployee::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ChannelOrgEmployee::getEnableStatus, statusEnum.getCode())
        .in(ChannelOrgEmployee::getId, idList)
        .list();
  }

  /**
   * 根据用户编码集合和渠道组织集合查询数据
   *
   * @param userCodes
   * @param channelOrgCodes
   * @return
   */
  public List<ChannelOrgEmployee> findByUserCodesAndChannelOrgCodes(Set<String> userCodes, Set<String> channelOrgCodes) {
    return this.lambdaQuery().eq(ChannelOrgEmployee::getTenantCode, TenantUtils.getTenantCode())
        .eq(ChannelOrgEmployee::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(ChannelOrgEmployee::getChannelOrgCode, channelOrgCodes)
        .in(ChannelOrgEmployee::getUserCode, userCodes)
        .list();
  }

  /**
   * 通过渠道组织编码查询数据
   *
   * @param channelOrgCode
   * @return
   */
  public List<ChannelOrgEmployee> findByChannelOrgCode(String channelOrgCode) {
    return this.lambdaQuery().eq(ChannelOrgEmployee::getTenantCode, TenantUtils.getTenantCode())
        .eq(ChannelOrgEmployee::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ChannelOrgEmployee::getChannelOrgCode, channelOrgCode)
        .list();
  }
}

